#ifndef HTTP_HPP
#define HTTP_HPP

#include "Common.hpp"

namespace Http
{
    void init();
    void cleanup();

    bool get(const std::string& url,
             const std::vector<std::string>* pHeaders,
             std::string* pResponse,
             std::string* pMsg = nullptr);

    bool getQuery(const std::string& url,
                  const std::vector<std::pair<std::string, std::string>>& query,
                  const std::vector<std::string>* pHeaders,
                  std::string* pResponse,
                  std::string* pMsg = nullptr);

    bool post(const std::string& url,
              const std::string& request,
              const std::string& contentType,
              const std::vector<std::string>* pHeaders,
              std::string* pResponse,
              std::string* pMsg = nullptr);

    bool postQuery(const std::string& url,
                   const std::vector<std::pair<std::string, std::string>>& query,
                   const std::vector<std::string>* pHeaders,
                   std::string* pResponse,
                   std::string* pMsg = nullptr);

    class MimeEntry
    {
    public:
        MimeEntry() {}
        MimeEntry(const std::string& name_,
                  const std::string& data_) :
            name(name_), data(data_) {}
        MimeEntry(const std::string& name_,
                  const std::string& data_,
                  const std::string& fileName_) :
            name(name_), data(data_), fileName(fileName_) {}

        std::string name;
        std::string data;
        std::string fileName;
    };

    bool postMime(const std::string& url,
                  const std::vector<MimeEntry>& mimeQuery,
                  const std::vector<std::string>* pHeaders,
                  std::string* pResponse,
                  std::string* pMsg = nullptr);
}

#endif
