#ifndef PROTOCOL_HPP
#define PROTOCOL_HPP

#include "Common.hpp"

class Problem;
class LeaderboardEntry;
class Solution;

namespace Protocol
{
    void init();
    void cleanup();

    bool getProblems(std::vector<Problem>* pProblems,
                     std::string* pMsg = nullptr);
    bool getLeaderboard(const std::string& problemName,
                        std::vector<LeaderboardEntry>* pLeaderboard,
                        std::string* pMsg = nullptr);
    bool registerTeam(const std::string& name,
                      const std::string& pl,
                      const std::string& email,
                      std::string* pApiKey,
                      std::string* pMsg = nullptr);
    bool select(const std::string& problemName,
                std::string* pMsg = nullptr);
    bool explore(const std::vector<std::string>& plans,
                 std::vector<std::vector<uint8_t>>* pResults,
                 uint64_t* pQueryCount,
                 std::string* pMsg = nullptr);
    bool guess(const Solution& solution,
               bool* pCorrect,
               std::string* pMsg = nullptr);

#if 0
    bool getProblemCount(std::string* pProblemCountData,
                         std::string* pMsg = nullptr);
    bool getProblem(uint64_t id,
                    std::string* pProblemData,
                    std::string* pMsg = nullptr);
    bool getScoreboard(std::string* pScoreboardData,
                       std::string* pMsg = nullptr);
    bool getUserboard(std::string* pUserboardData,
                      std::string* pMsg = nullptr);
    bool getSubmissions(uint64_t offset,
                        uint64_t limit,
                        std::string* pSubmissionsData,
                        std::string* pMsg = nullptr);
    bool getSubmissions(uint64_t offset,
                        uint64_t limit,
                        uint64_t id,
                        std::string* pSubmissionsData,
                        std::string* pMsg = nullptr);
    bool getSubmission(const std::string& submissionId,
                       std::string* pSubmissionData,
                       std::string* pMsg = nullptr);
    bool submit(uint64_t id,
                const std::string& solutionData,
                std::string* pSubmissionId,
                std::string* pMsg = nullptr);
    bool updateUsername(const std::string& username,
                        std::string* pMsg = nullptr);
#endif
}

#endif
