#include "Common.hpp"
#include "Cleanup.hpp"
#include "Protocol.hpp"
#include "Leaderboard.hpp"

using std::string;
using std::vector;

void usage()
{
    printf("Usage: getleaderboard [<problem>]\n");
    printf("  <problem>\n");
    printf("        Problem name (default: \"global\")\n");
    printf("Options:\n");
    printf("  -h    Print usage information and exit\n");
}

int main(int argc, char *argv[])
{
    bool gotProblemName = false;

    bool help = false;
    string problemName;

    int iArg = 1;
    while (iArg < argc)
    {
        string strArg = argv[iArg++];

        if (strArg == "-h" || strArg == "--help")
        {
            help = true;
        }
        else if (!gotProblemName)
        {
            problemName = strArg;
            gotProblemName = true;
        }
        else
        {
            usage();
            return 1;
        }
    }

    if (help)
    {
        usage();
        return 0;
    }

    if (!gotProblemName)
    {
        problemName = "global";
    }

    Protocol::init();
    Cleanup cleanupProtocol([](){ Protocol::cleanup(); });

    string msg;

    vector<LeaderboardEntry> leaderboard;
    if (!Protocol::getLeaderboard(problemName, &leaderboard, &msg))
    {
        printf("%s\n", msg.c_str());
        return 1;
    }

    for (auto& entry : leaderboard)
    {
        printf("%-40s %-20s", entry.name.c_str(), entry.pl.c_str());
        if (entry.valid)
        {
            printf(" %3" PRIu64 "", entry.score);
        }
        printf("\n");
    }

    return 0;
}
