#include "Common.hpp"
#include "Cleanup.hpp"
#include "Protocol.hpp"
#include "Problem.hpp"

using std::string;
using std::vector;

void usage()
{
    printf("Usage: getproblems\n");
    printf("Options:\n");
    printf("  -h    Print usage information and exit\n");
}

int main(int argc, char *argv[])
{
    bool help = false;

    int iArg = 1;
    while (iArg < argc)
    {
        string strArg = argv[iArg++];

        if (strArg == "-h" || strArg == "--help")
        {
            help = true;
        }
        else
        {
            usage();
            return 1;
        }
    }

    if (help)
    {
        usage();
        return 0;
    }

    Protocol::init();
    Cleanup cleanupProtocol([](){ Protocol::cleanup(); });

    string msg;

    vector<Problem> problems;
    if (!Protocol::getProblems(&problems, &msg))
    {
        printf("%s\n", msg.c_str());
        return 1;
    }

    for (auto& problem : problems)
    {
        printf("%-10s %3" PRIu64 "\n", problem.name.c_str(), problem.size);
    }

    return 0;
}
