#include "Common.hpp"
#include "Cleanup.hpp"
#include "Protocol.hpp"
#include "Solution.hpp"

using std::string;
using std::vector;

int main(int argc, char *argv[])
{
    Protocol::init();
    Cleanup cleanupProtocol([](){ Protocol::cleanup(); });

    string msg;

    if (!Protocol::select("probatio", &msg))
    {
        printf("%s\n", msg.c_str());
        return 1;
    }

    vector<string> plans;
    plans.push_back("012345342501403241254301204351304251204315243051234510");

    vector<vector<uint8_t>> results;
    uint64_t queryCount;
    if (!Protocol::explore(plans, &results, &queryCount, &msg))
    {
        printf("%s\n", msg.c_str());
        return 1;
    }

    for (auto& result : results)
    {
        for (uint8_t value : result)
        {
            printf("%" PRIu8 "", value);
        }
        printf("\n");
    }
    printf("queryCount = %" PRIu64 "\n", queryCount);

    uint64_t size = 3;
    Solution solution;
    for (uint64_t roomIdx = 0; roomIdx < size; roomIdx++)
    {
        solution.rooms.push_back(roomIdx % 4);
    }

    solution.startingRoom = 0;

    for (uint64_t roomIdx = 0; roomIdx < size; roomIdx++)
    {
        for (uint64_t doorIdx = 0; doorIdx < 6; doorIdx++)
        {
            auto& connection = solution.connections.emplace_back();
            connection.from.room = roomIdx;
            connection.from.door = doorIdx;
            connection.to.room = roomIdx;
            connection.to.door = doorIdx;
        }
    }

    bool correct;
    if (!Protocol::guess(solution, &correct, &msg))
    {
        printf("%s\n", msg.c_str());
        return 1;
    }

    printf("correct = %s\n", correct ? "true" : "false");

    return 0;
}
